<?php
	/**
	 * Augmit Social Widget
	 *
	 *
	 * @author 		basictheme
	 * @category 	Widgets
	 * @package 	Augmit/Widgets
	 * @version 	1.0.1
	 * @extends 	WP_Widget
	 */
	add_action('widgets_init', 'augmit_email_us_widget');
	function augmit_email_us_widget() {
		register_widget('augmit_email_us_widget');
	}
	
	
	class Augmit_Email_Us_Widget  extends WP_Widget{
		
		public function __construct(){
			parent::__construct('augmit_email_us_widget',esc_html__('Augmit Email Us Widget','advkt-toolkit'),array(
				'description' => esc_html__('Email Us Widget by Augmit','advkt-toolkit'),
			));
		}
		
		public function widget($args,$instance){
			extract($args);
			extract($instance);
		 	print $before_widget; 
             if($instance['title']):
                echo $before_title; ?> 
                    <?php echo apply_filters( 'widget_title', $instance['title'] ); ?>
                <?php echo $after_title; ?>
            <?php endif; ?>
		
                <div class="footer-widget widget_nav_menu">
                    <a href="mailto:<?php echo esc_attr( $email_address ); ?>" class="footer-widget-title"><?php echo esc_html( $email_address ); ?></a>
                    <p class="desc"><?php echo esc_html( $subtext ); ?></p>
                </div>


		
	    	<?php print $after_widget; ?>  
		<?php
		}
		

		/**
		 * widget function.
		 *
		 * @see WP_Widget
		 * @access public
		 * @param array $instance
		 * @return void
		 */
		public function form($instance){
			$title  = isset($instance['title'])? $instance['title']:'';
			$subtext  = isset($instance['subtext'])? $instance['subtext']:'';
			$email_address  = isset($instance['email_address'])? $instance['email_address']:'';
			
			?>
			<p>
				<label for="title"><?php esc_html_e('Title:','advkt-toolkit'); ?></label>
			</p>
			<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('title')); ?>"  name="<?php print esc_attr($this->get_field_name('title')); ?>" value="<?php print esc_attr($title); ?>">

			<p>
				<label for="subtext"><?php esc_html_e('Sub Heading','advkt-toolkit'); ?></label>
			    <input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('subtext')); ?>"  name="<?php print esc_attr($this->get_field_name('subtext')); ?>" value="<?php print esc_attr($subtext); ?>">
            </p>

			<p>
				<label for="email_address"><?php esc_html_e('Email Address','advkt-toolkit'); ?></label>
			    <input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('email_address')); ?>"  name="<?php print esc_attr($this->get_field_name('email_address')); ?>" value="<?php print esc_attr($email_address); ?>">
            </p>

			<?php
		}
				
		public function update( $new_instance, $old_instance ) {
			$instance = array();
			$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
			$instance['email_address'] = ( ! empty( $new_instance['email_address'] ) ) ? strip_tags( $new_instance['email_address'] ) : 'fa-regular fa-location-dot';
			$instance['subtext'] = ( ! empty( $new_instance['subtext'] ) ) ? strip_tags( $new_instance['subtext'] ) : '';
			
			return $instance;
		}
	}
