<?php
	/**
	 * Augmit Social Widget
	 *
	 *
	 * @author 		basictheme
	 * @category 	Widgets
	 * @package 	Augmit/Widgets
	 * @version 	1.0.1
	 * @extends 	WP_Widget
	 */
	add_action('widgets_init', 'augmit_contact_info_widget');
	function augmit_contact_info_widget() {
		register_widget('augmit_contact_info_widget');
	}
	
	
	class Augmit_Contact_Info_Widget  extends WP_Widget{
		
		public function __construct(){
			parent::__construct('augmit_contact_info_widget',esc_html__('Augmit CTA Widget','advkt-toolkit'),array(
				'description' => esc_html__('CTA Info Widget by Augmit','advkt-toolkit'),
			));
		}
		
		public function widget($args,$instance){
			extract($args);
			extract($instance);
		 	print $before_widget; 
             if($instance['title']):
                echo $before_title; ?> 
                    <?php echo apply_filters( 'widget_title', $instance['title'] ); ?>
                <?php echo $after_title; ?>
            <?php endif; ?>
		
		

                <a href="<?php echo esc_url( $link_url ); ?>" class="theme-btn">
                    <?php echo esc_html( $link_text ); ?>
                </a>


		
	    	<?php print $after_widget; ?>  
		<?php
		}
		

		/**
		 * widget function.
		 *
		 * @see WP_Widget
		 * @access public
		 * @param array $instance
		 * @return void
		 */
		public function form($instance){
			$title  = isset($instance['title'])? $instance['title']:'';
			$link_text  = isset($instance['link_text'])? $instance['link_text']:'';
			$link_url  = isset($instance['link_url'])? $instance['link_url']:'';
			
			?>
			<p>
				<label for="title"><?php esc_html_e('Title:','advkt-toolkit'); ?></label>
			</p>
			<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('title')); ?>"  name="<?php print esc_attr($this->get_field_name('title')); ?>" value="<?php print esc_attr($title); ?>">

			<p>
				<label for="link_text"><?php esc_html_e('Link Text','advkt-toolkit'); ?></label>
			    <input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('link_text')); ?>"  name="<?php print esc_attr($this->get_field_name('link_text')); ?>" value="<?php print esc_attr($link_text); ?>">
            </p>

			<p>
				<label for="link_url"><?php esc_html_e('Link Url','advkt-toolkit'); ?></label>
			    <input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('link_url')); ?>"  name="<?php print esc_attr($this->get_field_name('link_url')); ?>" value="<?php print esc_attr($link_url); ?>">
            </p>

			<?php
		}
				
		public function update( $new_instance, $old_instance ) {
			$instance = array();
			$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
			$instance['link_url'] = ( ! empty( $new_instance['link_url'] ) ) ? strip_tags( $new_instance['link_url'] ) : 'fa-regular fa-location-dot';
			$instance['link_text'] = ( ! empty( $new_instance['link_text'] ) ) ? strip_tags( $new_instance['link_text'] ) : '';
			
			return $instance;
		}
	}
