<?php
	/**
	 * torun Footer full Widget
	 *
	 *
	 * @author 		Nilartstudio
	 * @category 	Widgets
	 * @package 	torun/Widgets
	 * @version 	1.0.0
	 * @extends 	WP_Widget
	 */
	add_action('widgets_init', 'advkt_company_contact_info_widget');
	function advkt_company_contact_info_widget() {
		register_widget('advkt_company_contact_info_widget');
	}
	
	
	class Advkt_Company_Contact_Info_Widget  extends WP_Widget{
		
		public function __construct(){
			parent::__construct('advkt_company_contact_info_widget',esc_html__('Advkt Company Contact Info','advkt-toolkit'),array(
				'description' => esc_html__('Company Contact Info Footer Top Widget by Advkt','advkt-toolkit'),
			));
		}
		
		public function widget($args, $instance){
			extract($args);
			extract($instance);
			print $before_widget;
			?>

	
	
					<?php
					if ( ! empty( $title ) ) {
						echo $before_title . apply_filters( 'widget_title', $title ) . $after_title;
					} ?>

					<?php 
					if( $logo_url ): ?>
						<a href="<?php  print home_url(); ?>" class="logo-wrapper"><img src="<?php echo esc_url( $logo_url ); ?>" alt="Footer Logo" /></a>
					<?php 
					endif; ?>

					<div class="cta-wrapper">
						<?php
						if( $phone_label !== ""): ?>
							<span class="title"><?php echo esc_html($phone_label); ?></span>
						<?php
						endif; ?>

						<?php
						if( $phone_number !== ""): ?>
						<a href="tel:<?php echo esc_attr($phone_number); ?>"><?php echo esc_html($phone_number); ?></a>
						<?php
						endif; ?>
					</div>



				
       

              	<?php print $after_widget; ?>
			<?php 
		}
		

		/**
		 * widget function.
		 *
		 * @see WP_Widget
		 * @access public
		 * @param array $instance
		 * @return void
		 */
		public function form($instance){

			$title  = isset($instance['title'])? $instance['title']:'';
			$logo_url  = isset($instance['logo_url'])? $instance['logo_url']:'';
			$phone_label  = isset($instance['phone_label'])? $instance['phone_label']:'';
			$phone_number  = isset($instance['phone_number'])? $instance['phone_number']:'';
			?>
			<p>
				<label for="title"><?php esc_html_e('Title:','advkt-toolkit'); ?></label>
			</p>
			<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('title')); ?>"  name="<?php print esc_attr($this->get_field_name('title')); ?>" value="<?php print esc_attr($title); ?>">

			<p>
				<label for="logo_url"><?php esc_html_e('Logo Url:','advkt-toolkit'); ?></label>
			</p>
			<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('logo_url')); ?>"  name="<?php print esc_attr($this->get_field_name('logo_url')); ?>" value="<?php print esc_attr($logo_url); ?>">

			<p>
				<label for="phone_label"><?php esc_html_e('Phone Label: ','advkt-toolkit'); ?></label>
				<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('phone_label')); ?>"  name="<?php print esc_attr($this->get_field_name('phone_label')); ?>" value="<?php print esc_attr($phone_label); ?>">
			</p>

			<p>
				<label for="phone_number"><?php esc_html_e('Phone Number: ','advkt-toolkit'); ?></label>
				<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('phone_number')); ?>"  name="<?php print esc_attr($this->get_field_name('phone_number')); ?>" value="<?php print esc_attr($phone_number); ?>">
			</p>

		
			<?php
		}
				
		public function update( $new_instance, $old_instance ) {
			$instance = array();
			$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
			$instance['logo_url'] = ( ! empty( $new_instance['logo_url'] ) ) ? strip_tags( $new_instance['logo_url'] ) : '';
			$instance['phone_label'] = ( ! empty( $new_instance['phone_label'] ) ) ? strip_tags( $new_instance['phone_label'] ) : '';
			$instance['phone_number'] = ( ! empty( $new_instance['phone_number'] ) ) ? strip_tags( $new_instance['phone_number'] ) : '';


			return $instance;
		}
	}