<?php
	/**
	 * torun Footer full Widget
	 *
	 *
	 * @author 		Nilartstudio
	 * @category 	Widgets
	 * @package 	torun/Widgets
	 * @version 	1.0.0
	 * @extends 	WP_Widget
	 */
	add_action('widgets_init', 'advkt_about_info_widget');
	function advkt_about_info_widget() {
		register_widget('advkt_about_info_widget');
	}
	
	
	class Advkt_About_Info_Widget  extends WP_Widget{
		
		public function __construct(){
			parent::__construct('advkt_about_info_widget',esc_html__('Advkt About Info','advkt-toolkit'),array(
				'description' => esc_html__('About Info Widget by Advkt','advkt-toolkit'),
			));
		}
		
		public function widget($args, $instance){
			extract($args);
			extract($instance);
			
			echo $before_widget;                     
		?>
			<div class="footer-widget-info">
				<?php 
				if( $logo_url ): ?>
					<div class="footer-logo">
						<a href="<?php  echo home_url(); ?>"><img src="<?php echo esc_url( $logo_url ); ?>" alt="Footer Logo" /></a>
					</div>
				<?php 
				endif; ?>
				<?php
				if( $desc !== ""): ?>
					<p><?php echo $desc; ?></p>
				<?php
				endif; ?>

				<div class="social-profile">
					<?php 
					if($facebook_url !== ""): ?>
						<a href="<?php echo esc_url($facebook_url); ?>"><i class="fa-brands fa-facebook-f"></i></a>
					<?php 
					endif; ?>

					<?php 
					if($twitter_url !== ""): ?>
						<a href="<?php echo esc_url($twitter_url); ?>"><i class="fa-brands fa-twitter"></i></a>
					<?php 
					endif; ?>

					<?php
					if($instagram_url !== ""): ?>
						<a href="<?php echo esc_url($instagram_url); ?>"><i class="fa-brands fa-instagram"></i></a>
					<?php 
					endif; ?>

					<?php 
					if($pinterest_url !== "" ): ?>
						<a href="<?php echo esc_url($pinterest_url); ?>"><i class="fa-brands fa-pinterest-p"></i></a>
					<?php
					endif; ?>
				</div>
			</div>

            <?php echo $after_widget; 
		}
		

		/**
		 * widget function.
		 *
		 * @see WP_Widget
		 * @access public
		 * @param array $instance
		 * @return void
		 */
		public function form($instance){

			$title  = isset($instance['title'])? $instance['title']:'';
			$logo_url  = isset($instance['logo_url'])? $instance['logo_url']:'';
			$desc  = isset($instance['desc'])? $instance['desc']:'';


			$facebook_icon  = isset($instance['facebook_icon'])? $instance['facebook_icon']:'';
			$facebook_url  = isset($instance['facebook_url'])? $instance['facebook_url']:'';
			$twitter_icon  = isset($instance['twitter_icon'])? $instance['twitter_icon']:'';
			$twitter_url  = isset($instance['twitter_url'])? $instance['twitter_url']:'';
			$instagram_icon  = isset($instance['instagram_icon'])? $instance['instagram_icon']:'';
			$instagram_url  = isset($instance['instagram_url'])? $instance['instagram_url']:'';
			$pinterest_icon  = isset($instance['pinterest_icon'])? $instance['pinterest_icon']:'';
			$pinterest_url  = isset($instance['pinterest_url'])? $instance['pinterest_url']:'';

			?>
			<p>
				<label for="title"><?php esc_html_e('Title:','advkt-toolkit'); ?></label>
				<input class="widefat" type="text" id="<?php echo esc_attr($this->get_field_id('title')); ?>"  name="<?php echo esc_attr($this->get_field_name('title')); ?>" value="<?php echo esc_attr($title); ?>">
			</p>

			<p>
				<label for="logo_url"><?php esc_html_e('Logo Url:','advkt-toolkit'); ?></label>
				<input class="widefat" type="text" id="<?php echo esc_attr($this->get_field_id('logo_url')); ?>"  name="<?php echo esc_attr($this->get_field_name('logo_url')); ?>" value="<?php echo esc_attr($logo_url); ?>">
			</p>

			<p>
				<label for="desc"><?php esc_html_e('Description:','advkt-toolkit'); ?></label>
				<textarea class="widefat" rows="2" cols="15" id="<?php echo esc_attr($this->get_field_id('desc')); ?>" value="<?php echo esc_attr($desc); ?>" name="<?php echo esc_attr($this->get_field_name('desc')); ?>"><?php echo esc_attr($desc); ?></textarea>
			</p>

			<p>
				<label for="facebook_icon"><?php esc_html_e('Social Profile Icon 1:','advkt-toolkit'); ?></label>
				<input class="widefat" type="text" id="<?php echo esc_attr($this->get_field_id('facebook_icon')); ?>"  name="<?php echo esc_attr($this->get_field_name('facebook_icon')); ?>" value="<?php echo esc_attr($facebook_icon); ?>">
			</p>
			<p>
				<label for="facebook_url"><?php esc_html_e('Social Profile Link 1:','advkt-toolkit'); ?></label>
				<input class="widefat" type="text" id="<?php echo esc_attr($this->get_field_id('facebook_url')); ?>"  name="<?php echo esc_attr($this->get_field_name('facebook_url')); ?>" value="<?php echo esc_attr($facebook_url); ?>">
			</p>

			<p>
				<label for="title"><?php esc_html_e('Social Profile Icon 2:','advkt-toolkit'); ?></label>
				<input class="widefat" type="text" id="<?php echo esc_attr($this->get_field_id('twitter_icon')); ?>"  name="<?php echo esc_attr($this->get_field_name('twitter_icon')); ?>" value="<?php echo esc_attr($twitter_icon); ?>">
			</p>
			<p>
				<label for="title"><?php esc_html_e('Social Profile Link 2:','advkt-toolkit'); ?></label>
				<input class="widefat" type="text" id="<?php echo esc_attr($this->get_field_id('twitter_url')); ?>"  name="<?php echo esc_attr($this->get_field_name('twitter_url')); ?>" value="<?php echo esc_attr($twitter_url); ?>">
			</p>

			<p>
				<label for="instagram"><?php esc_html_e('Social Profile Icon 3:','advkt-toolkit'); ?></label>
				<input class="widefat" type="text" id="<?php echo esc_attr($this->get_field_id('instagram_icon')); ?>"  name="<?php echo esc_attr($this->get_field_name('instagram_icon')); ?>" value="<?php echo esc_attr($instagram_icon); ?>">
			</p>	
			<p>
				<label for="instagram"><?php esc_html_e('Social Profile Link 3:','advkt-toolkit'); ?></label>
				<input class="widefat" type="text" id="<?php echo esc_attr($this->get_field_id('instagram_url')); ?>"  name="<?php echo esc_attr($this->get_field_name('instagram_url')); ?>" value="<?php echo esc_attr($instagram_url); ?>">
			</p>	

			<p>
				<label for="pinterest"><?php esc_html_e('Social Profile Icon 4:','advkt-toolkit'); ?></label>
				<input class="widefat" type="text" id="<?php echo esc_attr($this->get_field_id('pinterest_icon')); ?>"  name="<?php echo esc_attr($this->get_field_name('pinterest_icon')); ?>" value="<?php echo esc_attr($pinterest_icon); ?>">
			</p>

			<p>
				<label for="pinterest"><?php esc_html_e('Social Profile Link 4:','advkt-toolkit'); ?></label>
				<input class="widefat" type="text" id="<?php echo esc_attr($this->get_field_id('pinterest_url')); ?>"  name="<?php echo esc_attr($this->get_field_name('pinterest_url')); ?>" value="<?php echo esc_attr($pinterest_url); ?>">
			</p>
			
			
			<?php
		}
				
		public function update( $new_instance, $old_instance ) {
			$instance = array();
			$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
			$instance['logo_url'] = ( ! empty( $new_instance['logo_url'] ) ) ? strip_tags( $new_instance['logo_url'] ) : '';
			$instance['desc'] = ( ! empty( $new_instance['desc'] ) ) ? strip_tags( $new_instance['desc'] ) : '';


			$instance['facebook_icon'] = ( ! empty( $new_instance['facebook_icon'] ) ) ? strip_tags( $new_instance['facebook_icon'] ) : '';
			$instance['facebook_url'] = ( ! empty( $new_instance['facebook_url'] ) ) ? strip_tags( $new_instance['facebook_url'] ) : '';
			$instance['twitter_icon'] = ( ! empty( $new_instance['twitter_icon'] ) ) ? strip_tags( $new_instance['twitter_icon'] ) : '';
			$instance['twitter_url'] = ( ! empty( $new_instance['twitter_url'] ) ) ? strip_tags( $new_instance['twitter_url'] ) : '';
			$instance['instagram_icon'] = ( ! empty( $new_instance['instagram_icon'] ) ) ? strip_tags( $new_instance['instagram_icon'] ) : '';
			$instance['instagram_url'] = ( ! empty( $new_instance['instagram_url'] ) ) ? strip_tags( $new_instance['instagram_url'] ) : '';
			$instance['pinterest_icon'] = ( ! empty( $new_instance['pinterest_icon'] ) ) ? strip_tags( $new_instance['pinterest_icon'] ) : '';
			$instance['pinterest_url'] = ( ! empty( $new_instance['pinterest_url'] ) ) ? strip_tags( $new_instance['pinterest_url'] ) : '';

			return $instance;
		}
	}