<?php 
class AdvktServicePost 
{
	function __construct() {
		add_action( 'init', array( $this, 'register_custom_post_type' ) );
		add_action( 'init', array( $this, 'create_cat' ) );
		add_filter( 'cmb2_meta_boxes', array( $this, 'add_meta' ) );
		add_filter( 'template_include', array( $this, 'service_template_include' ) );
	}
	
	public function service_template_include( $template ) {
		if ( is_singular( 'advkt-service' ) ) {
			return $this->get_template( 'single-advkt-service.php');
		}
		return $template;
	}
	
	public function get_template( $template ) {
		if ( $theme_file = locate_template( array( $template ) ) ) {
			$file = $theme_file;
		} else {
			$file = ADVKT_TOOLKIT_DIR . '/template/'. $template;
		}
		return apply_filters( __FUNCTION__, $file, $template );
	}
	
	
	public function register_custom_post_type() {

		$labels = array(
			'name'               => __( 'Service', 'Post Type General Name', 'advkt-toolkit'),
			'singular_name'      => __( 'Service', 'Post Type Singular Name', 'advkt-toolkit'),
			'menu_name'          => __( 'Services', 'advkt-toolkit'),
			'parent_item_colon'  => __( 'Parent Service', 'advkt-toolkit'),
			'all_items'          => __( 'All  Services', 'advkt-toolkit'),
			'view_item'          => __( 'View  Services', 'advkt-toolkit'),
			'add_new_item'       => __( 'Add New  Service', 'advkt-toolkit'),
			'add_new'            => __( 'Add New  Service', 'advkt-toolkit'),
			'edit_item'          => __( 'Edit  Service', 'advkt-toolkit'),
			'update_item'        => __( 'Update  Service', 'advkt-toolkit'),
			'search_items'       => __( 'Search  Service', 'advkt-toolkit'),
			'not_found'          => __( 'Not found', 'advkt-toolkit'),
			'not_found_in_trash' => __( 'Not found in Trash', 'advkt-toolkit'),
		);

		$args   = array(
			'label'               => __( 'Service', 'advkt-toolkit'),
			'description'         => __( 'Create and manage all bdevs Service', 'advkt-toolkit'),
			'labels'              => $labels,
			'supports'            => array( 'title','thumbnail', 'editor'),
			'hierarchical'        => false,
			'public'              => true,
			'show_ui'             => true,
			'show_in_menu'        => true,
			'show_in_nav_menus'   => true,
			'show_in_admin_bar'   => true,
			'menu_position'       => 14,
			'rewrite'             =>  array( 'slug' => 'services', 'with_front' => false ),
			'can_export'          => true,
			'has_archive'         => true,
			'exclude_from_search' => false,
			'publicly_queryable'  => true,
			'capability_type'     => 'post',
			'menu_icon'           => 'dashicons-smiley',
		);

		register_post_type( 'advkt-service', $args );
	}
	
	public function create_cat() {

		$name = 'Category';

		$labels = array(
			'name'              => esc_html($name),
			'singular_name'     => esc_html($name),
			'search_items'      => sprintf(esc_html__( 'Search %s:', 'advkt-toolkit' ),$name),
			'all_items'      	=> sprintf(esc_html__( 'All %s:', 'advkt-toolkit' ),$name),
			'parent_item'      	=> sprintf(esc_html__( 'Parent  %s:', 'advkt-toolkit' ),$name),
			'parent_item_colon' => sprintf(esc_html__( 'Parent  %s:', 'advkt-toolkit' ),$name),
			'edit_item'     	=> sprintf(esc_html__( 'Edit  %s:', 'advkt-toolkit' ),$name),
			'update_item'     	=> sprintf(esc_html__( 'Update %s:', 'advkt-toolkit' ),$name),
			'add_new_item'      => sprintf(esc_html__( 'Add New %s:', 'advkt-toolkit' ),$name),
			'new_item_name'     => sprintf(esc_html__( 'New  %s Name:', 'advkt-toolkit' ),$name),
			'menu_name'      	=> esc_html($name),
		);

		$args = array(
			'hierarchical'      => true,
			'labels'            => $labels,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'category' ),
		);

		register_taxonomy('service_categories','advkt-service', $args );
	}

	
	public function add_meta(array $advkt) {

		$advkt[] = array(
			'id'           => 'advkt-service',
			'title'        => esc_html__( 'Service Details Info', 'advkt-toolkit' ),
			'object_types' => array( 'advkt-service'),
			'fields'       => array(
				array(
			        'name' => esc_html__('Service Icon Image','advkt-toolkit'),
			        'type' => 'file',
			        'id' => 'service_icon_image',
					'desc' => 'Upload image having width 64px and height 55px for better outlook',
				),
				array(
			        'name' => esc_html__('Service Icon','advkt-toolkit'),
			        'type' => 'text',
			        'id' => 'service_icon'
				),
				array(
					'name'    => 'Tiny Content',
					'desc'    => 'Service Content',
					'id'      => 'service_tiny_text',
					'type'    => 'wysiwyg',
					'options' => array(
						'wpautop' => true, // use wpautop?
						'media_buttons' => true, // show insert/upload button(s)
						'textarea_name' => [], // set the textarea name to something different, square brackets [] can be used here
						'textarea_rows' => get_option('default_post_edit_rows', 10), // rows="..."
						'tabindex' => '',
						'editor_css' => '', // intended for extra styles for both visual and HTML editors buttons, needs to include the `<style>` tags, can use "scoped".
						'editor_class' => '', // add extra class(es) to the editor textarea
						'teeny' => false, // output the minimal editor config used in Press This
						'dfw' => false, // replace the default fullscreen with DFW (needs specific css)
						'tinymce' => true, // load TinyMCE, can be used to pass settings directly to TinyMCE using an array()
						'quicktags' => true // load Quicktags, can be used to pass settings directly to Quicktags using an array()
					),
				),					
			)
		);
		return $advkt;
	}
}

new AdvktServicePost();