<?php
namespace AdvktElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Advkt Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class AdvktTestimonials extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Advkt Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'advkt-testimonials';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Advkt Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'AT Testimonials', 'advkt-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Boomdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-testimonial';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Boomdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'advkt-elementor' ];
	}

	public function get_keywords() {
		return [ 'testimonial' ];
	}

	public function get_script_depends() {
		return [ 'advkt-elementor'];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content_features',
			[
				'label' => esc_html__( 'Testimonials', 'advkt-elementor' ),
			]
		);

		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Chose Style', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'testimonial-style-1'  => esc_html__( 'Testimonial Style 1', 'advkt-elementor' ),
					'testimonial-style-2' => esc_html__( 'Testimonial Style 2', 'advkt-elementor' )
				],
				'default'   => 'testimonial-style-1',
			]
		);

		$this->add_control(

			'tabs',
			[
				'label' => esc_html__( 'Testimonial Items', 'advkt-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'tab_name'   => esc_html__( 'Testimonial #1', 'advkt-elementor' ),
					]
				],
				'fields' => [										
					[
						'name'        => 'tab_name',
						'label'       => esc_html__( 'Name', 'advkt-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Jon Haris' , 'advkt-elementor' ),
						'label_block' => true,
					],					
					[
						'name'        => 'designation_name',
						'label'       => esc_html__( 'Designation Name ', 'advkt-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Web Developer' , 'advkt-elementor' ),
						'label_block' => true,
					],
					[
						'name'       => 'tab_desc',
						'label'      => esc_html__( 'Description', 'advkt-elementor' ),
						'type'       => Controls_Manager::TEXTAREA,
						'dynamic'    => [ 'active' => true ],
						'default'    => esc_html__( 'Description here....', 'advkt-elementor' ),
						'placeholder'    => esc_html__( 'Enter Description here....', 'advkt-elementor' ),
						'show_label' => true,
					],
					[
						'name'    => 'tab_image',
						'label'   => esc_html__( 'Author Image', 'advkt-elementor' ),
						'type' => \Elementor\Controls_Manager::MEDIA,
						'default' => [
							'url' => \Elementor\Utils::get_placeholder_image_src(),
						],
						'dynamic' => [ 'active' => true ],
					],
					[
						'name'    => 'tab_brand_image',
						'label'   => esc_html__( 'Brand Image', 'advkt-elementor' ),
						'type' => \Elementor\Controls_Manager::MEDIA,
						'default' => [
							'url' => \Elementor\Utils::get_placeholder_image_src(),
						],
						'dynamic' => [ 'active' => true ],
					],
				],
			]
		);

		$this->end_controls_section();

		/** Start Slider Settings **/
		$this->start_controls_section(
			'slider_widget_settings',
			[
				'label' => __( 'Slider Settings', 'boomdevs-elementor' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'slider_widget_autoplay',
			[
				'label'   => __('Autoplay', 'boomdevs-elementor'),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'slider_widget_autoplay_speed',
			[
				'label'     => esc_html__('Autoplay Speed', 'boomdevs-elementor'),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 3000,
				'condition' => [
					'slider_widget_autoplay' => 'yes',
				],
			]
		);

		$this->add_control(
			'slider_widget_pause_hover',
			[
				'label'   => __('Pause on Hover', 'boomdevs-elementor'),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'slider_widget_loop',
			[
				'label'   => __('Loop', 'boomdevs-elementor'),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'slider_widget_slide_animation_speed',
			[
				'label'     => esc_html__('Animation Speed (ms)', 'boomdevs-elementor'),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 1500,
			]
		);

		$this->add_control(
			'slider_widget_slides_show_desktop',
			[
				'label'     => esc_html__('Slides to display desktop', 'boomdevs-elementor'),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 1,
			]
		);

		$this->add_control(
			'slider_widget_slides_show_tablet',
			[
				'label'     => esc_html__('Slides to display tablet', 'boomdevs-elementor'),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 1,
			]
		);

		$this->add_control(
			'slider_widget_slides_show_mobile',
			[
				'label'     => esc_html__('Slides to display mobile', 'boomdevs-elementor'),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 1,
			]
		);

		$this->add_control(
			'slider_widget_slides_scroll',
			[
				'label'     => esc_html__('Number of slides to scroll', 'boomdevs-elementor'),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 1,
			]
		);

		$this->add_control(
			'slider_widget_dots',
			[
				'label'   => __('Dots', 'boomdevs-elementor'),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'slider_widget_arrows',
			[
				'label'   => __('Arrows', 'boomdevs-elementor'),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'no',
			]
		);

		$this->add_control(
			'slider_widget_swipe_slide',
			[
				'label'   => __('swipeToSlide', 'boomdevs-elementor'),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

		/** End Carousel Settings **/

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'advkt-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'advkt-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->add_control(
			'show_tab_name',
			[
				'label'   => esc_html__( 'Show Name', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		

		$this->add_control(
			'show_tab_image',
			[
				'label'   => esc_html__( 'Show Image', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);

		$this->add_control(
			'show_tab_brand_image',
			[
				'label'   => esc_html__( 'Show Brand Image', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);

		$this->add_control(
			'show_designation_name',
			[
				'label'   => esc_html__( 'Show Designation', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);

		$this->add_control(
			'show_tab_desc',
			[
				'label'   => esc_html__( 'Show Description', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);
		

		$this->end_controls_section();


		/** typography **/
		$this->start_controls_section(
			'testimonial_name_style',
			[
				'label' => esc_html__( 'Name Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'testimonial_author_typography',
				'selector' => '{{WRAPPER}} .testimonial-card .user-info .info h3.name',
			]
		);

		$this->add_control(
			'testimonial_name_color',
			[
				'label' => __( 'Color', 'advkt-elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .testimonial-card .user-info .info h3.name' => 'color: {{VALUE}};',
				]
			]
		);



		$this->end_controls_section();



		/** Designation typography **/
		$this->start_controls_section(
			'testimonial_designation_style',
			[
				'label' => esc_html__( 'Designation Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);


		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'testimonial_designation_typography',
				'selector' => '{{WRAPPER}} .testimonial-card .user-info .info h3.name',
			]
		);

		$this->add_control(
            'testimonial_designation_color',
            [
                'label' => __( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .testimonial-card .user-info .info p.designation' => 'color: {{VALUE}};',
                ]
            ]
        );


		$this->end_controls_section();

		/** Statement typography **/
		$this->start_controls_section(
			'testimonial_statement_style',
			[
				'label' => esc_html__( 'Description Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);


		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'testimonial_statement_typography',
				'selector' => '{{WRAPPER}} .testimonial-card .user-info .info h3.name',
			]
		);

		$this->add_control(
            'testimonial_statement_color',
            [
                'label' => __( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .testimonial-card .content p.text' => 'color: {{VALUE}};',
                ]
            ]
        );

		

		$this->end_controls_section();

		

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract( $settings );

		$autoplay 				= $settings['slider_widget_autoplay'] === 'yes' ? 'true' : 'false';
		$loop 					= $settings['slider_widget_loop'] === 'yes' ? 'true' : 'false';
		$dots 					= $settings['slider_widget_dots'] === 'yes' ? 'true' : 'false';
		$arrows 				= $settings['slider_widget_arrows'] === 'yes' ? 'true' : 'false';
		$swipe_slide 			= $settings['slider_widget_swipe_slide'] === 'yes' ? 'true' : 'false';
		$pause_hover 			= $settings['slider_widget_pause_hover'] === 'yes' ? 'true' : 'false';
		$slide_speed 			= $settings['slider_widget_slide_animation_speed'];
		$autoplay_speed 		= $settings['slider_widget_autoplay_speed'];
		$slides_show_desktop 	= $settings['slider_widget_slides_show_desktop'];
		$slides_show_tablet 	= $settings['slider_widget_slides_show_tablet'];
		$slides_show_mobile 	= $settings['slider_widget_slides_show_mobile'];
		$slides_scroll 			= $settings['slider_widget_slides_scroll'];

		$this->add_render_attribute(
			'slider_options',
			[
				'id' => 'slider-carousel-' . $this->get_id(),
				'data-autoplay' 			=> $autoplay,
				'data-autoplay-speed' 		=> $autoplay_speed,
				'data-slide-speed' 			=> $slide_speed,
				'data-slides-show-desktop' 	=> $slides_show_desktop,
				'data-slides-show-tablet' 	=> $slides_show_tablet,
				'data-slides-show-mobile' 	=> $slides_show_mobile,
				'data-slides-scroll' 		=> $slides_scroll,
				'data-loop' 				=> $loop,
				'data-dots' 				=> $dots,
				'data-arrows' 				=> $arrows,
				'data-swipe-slide' 			=> $swipe_slide,
				'data-pause-hover' 			=> $pause_hover,
			]
		);
	
		if( $chose_style == 'testimonial-style-1' ): ?>

<!-- .testimonial-card.style-1 .user-info .info h3.name -->
			<div class="testimonial-slider">
				<div class="testimonial-slider-wrapper " id="testimonial_one" <?php echo $this->get_render_attribute_string( 'slider_options' ); ?>>
					<?php 
					foreach ( $settings['tabs'] as $item ) : ?>
						<div class="slick-item">
							<div class="testimonial-card style-1">
								<div class="content-wrapper">
									<div class="content">
										<?php 
										if (( '' !== $item['tab_desc'] ) && ( $settings['show_tab_desc'] )) : ?>
											<p class="text"><?php echo wp_kses_post($item['tab_desc']); ?></p>
										<?php 
										endif; ?>
									</div>
									<div class="meta-user">
										<div class="user-info">
											<?php				
											if (( '' !== $item['tab_image'] ) && ( $settings['show_tab_image'] )) : 
											$image_src = wp_get_attachment_image_src( $item['tab_image']['id'], 'full' );
											$image = $image_src ? $image_src[0] : ''; 
											?>
												<div class="image">
													<img src="<?php print esc_url($image); ?>" alt="support" />
												</div>
											<?php 
											endif; ?>
											<div class="info">
												<?php 
												if (( '' !== $item['tab_name'] ) && ( $settings['show_tab_name'] )) : ?>
													<h3 class="name"><?php echo wp_kses_post($item['tab_name']); ?></h3>
												<?php 
												endif; ?>

												<?php 
												if (( '' !== $item['designation_name'] ) && ( $settings['show_designation_name'] )) : ?>
													<p class="designation"><?php echo wp_kses_post($item['designation_name']); ?></p>
												<?php 
												endif; ?>

											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
						<?php
					endforeach;
					?>
				</div>
			</div>

		<?php 
		elseif( $chose_style == 'testimonial-style-2' ): ?>

			<div class="testimonial-slider-wrapper" id="testimonial_two" <?php echo $this->get_render_attribute_string( 'slider_options' ); ?>>
				<?php 
				foreach ( $settings['tabs'] as $item ) : ?>
					<div>
						<div class="testimonial-card style-2">
							<div class="content-wrapper">
								<div class="meta-user">
									<div class="user-info">
										<?php				
										if (( '' !== $item['tab_image'] ) && ( $settings['show_tab_image'] )) : 
										$image_src = wp_get_attachment_image_src( $item['tab_image']['id'], 'full' );
										$image = $image_src ? $image_src[0] : ''; 
										?>
											<div class="image">
												<img src="<?php print esc_url($image); ?>" alt="support" />
											</div>
										<?php 
										endif; ?>
										


										<div class="info">
											<?php 
											if (( '' !== $item['tab_name'] ) && ( $settings['show_tab_name'] )) : ?>
												<h3 class="name"><?php echo wp_kses_post($item['tab_name']); ?></h3>
											<?php 
											endif; ?>

											<?php 
											if (( '' !== $item['designation_name'] ) && ( $settings['show_designation_name'] )) : ?>
												<p class="designation"><?php echo wp_kses_post($item['designation_name']); ?></p>
											<?php 
											endif; ?>
										</div>
									</div>
								</div>
								<div class="content">
									<?php 
									if (( '' !== $item['tab_desc'] ) && ( $settings['show_tab_desc'] )) : ?>
										<p class="text"><?php echo wp_kses_post($item['tab_desc']); ?></p>
									<?php 
									endif; ?>
								</div>
							</div>
							<div class="icon-wrapper">
								<?php				
								if (( '' !== $item['tab_brand_image'] ) && ( $settings['show_tab_brand_image'] )) : 
								$brand_image_src = wp_get_attachment_image_src( $item['tab_brand_image']['id'], 'full' );
								$brand_image = $brand_image_src ? $brand_image_src[0] : ''; 
								?>
									<div class="icon">
										<img src="<?php print esc_url($brand_image); ?>" alt="support" />
									</div>
								<?php 
								endif; ?>
							</div>
						</div>
					</div>
					<?php
				endforeach;
				?>
			</div>

		<?php
		endif; ?>		
	<?php
	}

}