<?php
namespace AdvktElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Advkt Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class AdvktPricing extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Advkt Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'advkt-pricing';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Advkt Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'At Pricing', 'advkt-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Boomdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-price-table';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Boomdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'advkt-elementor' ];
	}

	public function get_keywords() {
		return [ 'price' ];
	}

	public function get_script_depends() {
		return [ 'advkt-elementor'];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content_heading',
			[
				'label' => esc_html__( 'Pricing', 'advkt-elementor' ),
			]
		);

		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Chose Style', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'price_style_1'  => esc_html__( 'Price Style 1', 'advkt-elementor' ),
					'price_style_2' => esc_html__( 'Price Style 2', 'advkt-elementor' ),
				],
				'default'   => 'price_style_1',
			]
		);


		
		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'FAQ Item', 'advkt-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'tab_title'   => esc_html__( 'FAQ Number', 'advkt-elementor' ),
						'tab_content' => esc_html__( 'FAQ Content', 'advkt-elementor' ),
					]
				],
				'fields' => [											
					[
						'name'        => 'tab_active',
						'dynamic'     => [ 'active' => true ],
						'label' => esc_html__( 'Active Item', 'advkt-elementor' ),
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'label_on' => esc_html__( 'Show', 'advkt-elementor' ),
						'label_off' => esc_html__( 'Hide', 'advkt-elementor' ),
						'return_value' => 'yes',
						'default' => 'no',
						'label_block' => true,
					],
					[
						'name'        => 'tab_title',
						'label'       => esc_html__( 'Title', 'advkt-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Title' , 'advkt-elementor' ),
						'label_block' => true,
					],
					[
						'name'    => 'tab_image',
						'label'   => esc_html__( 'Image', 'bdevs-elementor' ),
						'type' => \Elementor\Controls_Manager::MEDIA,
						'default' => [
							'url' => \Elementor\Utils::get_placeholder_image_src(),
						],
						'dynamic' => [ 'active' => true ],
					],									
					[
						'name'        => 'tab_price_icon',
						'label'       => esc_html__( 'Money Icon', 'advkt-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( '$' , 'advkt-elementor' ),
						'label_block' => true,
					],									
					[
						'name'        => 'tab_price_price',
						'label'       => esc_html__( 'Money', 'advkt-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( '299' , 'advkt-elementor' ),
						'label_block' => true,
					],									
					[
						'name'        => 'tab_price_desc',
						'label'       => esc_html__( 'Time', 'advkt-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Per Percel' , 'advkt-elementor' ),
						'label_block' => true,
					],									
					[
						'name'       => 'tab_content',
						'label'      => esc_html__( 'Content', 'advkt-elementor' ),
						'type'       => Controls_Manager::TEXTAREA,
						'dynamic'    => [ 'active' => true ],
						'default'    => esc_html__( 'Pricing Content', 'advkt-elementor' ),
						'show_label' => false,
					],
					[
						'name'        => 'tab_price_btn',
						'label'       => esc_html__( 'Time', 'advkt-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Read More' , 'advkt-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'tab_link',
						'label'       => esc_html__( 'Button Link', 'advkt-elementor' ),
						'type'        => Controls_Manager::URL,
						'dynamic'     => [ 'active' => true ],
						'placeholder' => 'http://your-link.com',
						'default'     => [
							'url' => '#',
						],
					],
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'advkt-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'advkt-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);	

		$this->add_control(
			'show_heading_section',
			[
				'label'   => esc_html__( 'Show Heading Section', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_sub_heading',
			[
				'label'   => esc_html__( 'Show Sub Title', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [
					'show_heading_section' => 'yes'
				],
			]
		);	

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show title', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [
					'show_heading_section' => 'yes'
				],
			]
		);	

		$this->end_controls_section();


		/** heading typography **/
		$this->start_controls_section(
			'pricing_heading_style',
			[
				'label' => esc_html__( 'Heading Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
            'pricing_heading_font_color',
            [
                'label' => __( 'Heading Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .price-card .card-title .title' => 'color: {{VALUE}} !important;',
                ]
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'pricing_heading_typography',
				'selector' => '{{WRAPPER}} .price-card .card-title .title',
			]
		);

		$this->end_controls_section();


		/** pricing icon typography **/
		$this->start_controls_section(
			'pricing_price_icon_style',
			[
				'label' => esc_html__( 'Pricing Icon Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
            'pricing_icon_font_color',
            [
                'label' => __( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .price-card .price .price-heading .currency' => 'color: {{VALUE}} !important;',
                ]
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'pricing_icon_typography',
				'selector' => '{{WRAPPER}} .price-card .price .price-heading .currency',
			]
		);


		$this->end_controls_section();


		/** price typography **/
		$this->start_controls_section(
			'pricing_price_style',
			[
				'label' => esc_html__( 'Price Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);


		$this->add_control(
            'pricing_price_font_color',
            [
                'label' => __( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .price-card .price .price-heading' => 'color: {{VALUE}} !important;',
                ]
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'pricing_price_typography',
				'selector' => '{{WRAPPER}} .price-card .price .price-heading',
			]
		);

		
		$this->end_controls_section();

		/** time typography **/
		$this->start_controls_section(
			'pricing_time_style',
			[
				'label' => esc_html__( 'Price Time Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);


		$this->add_control(
            'pricing_time_font_color',
            [
                'label' => __( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .price-card .price .price-desc' => 'color: {{VALUE}} !important;',
                ]
            ]
        );


		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'pricing_time_typography',
				'selector' => '{{WRAPPER}} .price-card .price .price-desc',
			]
		);
	
		$this->end_controls_section();

		/** Description typography **/
		$this->start_controls_section(
			'pricing_content_style',
			[
				'label' => esc_html__( 'Description Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);


		$this->add_control(
            'pricing_content_font_color',
            [
                'label' => __( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .price-card .list ul li' => 'color: {{VALUE}} !important;',
                ]
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'pricing_content_typography',
				'selector' => '{{WRAPPER}} .price-card .list ul li',
			]
		);


		$this->add_control(
            'pricing_content_icon_font_color',
            [
                'label' => __( 'Icon Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .price-card .list ul li i' => 'color: {{VALUE}} !important;',
                ]
            ]
        );

		$this->add_control(
			'pricing_content_icon_font_size',
			[
				'label' => __( 'Icon Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .price-card .list ul li i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();




				
		/** Start Button **/
		$this->start_controls_section(
			'banner_btn_style',
			[
				'label' => esc_html__( 'Button Style', 'eyewell-elementor'),
				'tab' => Controls_Manager::TAB_STYLE,
				
			]
		);

		$this->start_controls_tabs(
			'style_tabs'
		);


		$this->start_controls_tab(
			'style_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'textdomain' ),
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'banner_btn_typography',
				'selector' => '{{WRAPPER}} .price-card .price-btn',
			]
		);
		
		$this->add_responsive_control(
			'banner_btn_text_color',
			[
				'label' => esc_html__( 'Text Color', 'eyewell-elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .price-card .price-btn' => 'color: {{VALUE}} !important',
				],
			]
		);
		
		$this->add_responsive_control(
			'banner_btn_bg_color',
			[
				'label' => esc_html__( 'Background Color', 'eyewell-elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .price-card .price-btn' => 'background: {{VALUE}} !important',
				],
			]
		);
		
		$this->add_responsive_control(
			'banner_btn_margin',
			[
				'label' => esc_html__( 'Margin', 'eyewell-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .price-card .price-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'banner_btn_padding',
			[
				'label' => esc_html__( 'Padding', 'eyewell-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .price-card .price-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'banner_btn_border_border',
				'selector' => '{{WRAPPER}} .price-card .price-btn',
			]
		);
		
		$this->add_responsive_control(
			'banner_btn_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'eyewell-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .price-card .price-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'style_hover_tab',
			[
				'label' => esc_html__( 'Hover', 'textdomain' ),
			]
		);

		
		$this->add_responsive_control(
			'banner_btn_hover_color',
			[
				'label' => esc_html__( 'Color', 'eyewell-elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .price-card .price-btn:hover' => 'color: {{VALUE}} !important',
				],
			]
		);

		$this->add_responsive_control(
			'banner_btn_bg_hover_color',
			[
				'label' => esc_html__( 'Background Color', 'eyewell-elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .price-card .price-btn:hover' => 'background: {{VALUE}} !important',
				],
			]
		);

		$this->add_responsive_control(
			'banner_btn_icon_hover_color',
			[
				'label' => esc_html__( 'Icon Color', 'eyewell-elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .price-card .price-btn:hover i' => 'color: {{VALUE}} !important',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_section();





	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract( $settings );

		if( $chose_style == 'price_style_1' ):  ?>

			<div class="pricing-content-area">
				<div class="container">
					<div class="row gy-4">
						<?php 
						foreach ( $settings['tabs'] as $item ) :
							extract( $item );
							$this->add_render_attribute(
								[
									'price-link' => [
										'href'   => $item['tab_link']['url'] ? esc_url($item['tab_link']['url']) : '#',
										'target' => $item['tab_link']['is_external'] ? '_blank' : '_self'
									]
								], '', '', true
							); ?>
							<div class="col-md-6 col-lg-4">
								<div class="price-card">
									<?php
									if( $tab_active == 'yes' ): ?>
									<div class="trend-badge">
										<div class="trend-down"></div>
									</div>
									<?php
									endif; ?>

									<?php
									if ( '' !== $item['tab_image'] )  : 
										$image_src = wp_get_attachment_image_src( $item['tab_image']['id'], 'full' );
										$image = $image_src ? $image_src[0] : ''; 
										?>
										<div class="price-bg-frame">
											<img src="<?php print esc_url($image); ?>" alt="">
										</div>
									<?php 
									endif; ?>

									<div class="card-title">
										<?php
										if(	$tab_title !== "" ): ?>
											<p class="title"><?php echo wp_kses_post( $tab_title ); ?></p>
										<?php
										endif; ?>
									</div>
									<div class="price">
										<h1 class="price-heading">
											<span class="currency"><?php echo wp_kses_post( $tab_price_icon ); ?></span><?php echo wp_kses_post( $tab_price_price ); ?>
										</h1>
										<?php
										if( $tab_price_desc !== "" ): ?>
										<p class="price-desc"><?php echo wp_kses_post( $tab_price_desc ); ?></p>
										<?php
										endif; ?>
									</div>
									<div class="list-wrapper">
										<div class="list">
											<?php echo wp_kses_post( $tab_content ); ?>
										</div>
									</div>
									<a <?php echo $this->get_render_attribute_string( 'price-link' ); ?> class="price-btn"><?php echo wp_kses_post( $tab_price_btn ); ?> <i class="fa-light fa-arrow-right"></i></a>
								</div>
							</div>
						<?php
						endforeach;
						?>
					</div>
				</div>
			</div>
		
        <?php 
        elseif( $chose_style == 'price_style_2' ): ?>


        <?php 
    	endif; ?>	
    <?php 
	}
}