<?php
namespace AdvktElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Advkt Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class AdvktHistory extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Advkt Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'advkt-history';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Advkt Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'AT History', 'advkt-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Advkt Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-history';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Advkt Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'advkt-elementor' ];
	}

	public function get_keywords() {
		return [ 'history' ];
	}

	public function get_script_depends() {
		return [ 'advkt-elementor'];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content_section',
			[
				'label' => esc_html__( 'Section', 'advkt-elementor' ),
			]
		);

		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Chose Style', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'history-style-1'  => esc_html__( 'History Style 1', 'advkt-elementor' ),
					'history-style-2' => esc_html__( 'History Style 2', 'advkt-elementor' ),
				],
				'default'   => 'history-style-1',
			]
		);


		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'List Item', 'advkt-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'tab_year'   => esc_html__( 'FAQ Number', 'advkt-elementor' ),
						'tab_content' => esc_html__( 'FAQ Content', 'advkt-elementor' ),
					]
				],
				'fields' => [											
					[
						'name'        => 'tab_year',
						'label'       => esc_html__( 'Year', 'advkt-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( '2010' , 'advkt-elementor' ),
						'label_block' => true,
					],									
					[
						'name'       => 'tab_content',
						'label'      => esc_html__( 'Content', 'advkt-elementor' ),
						'type'       => Controls_Manager::TEXTAREA,
						'dynamic'    => [ 'active' => true ],
						'default'    => esc_html__( 'Faq Content', 'advkt-elementor' ),
						'show_label' => true,
					],
					[
						'name'        => 'tab_icon',
						'label'       => esc_html__( 'Brand Logo', 'advkt-elementor' ),
						'type' => \Elementor\Controls_Manager::MEDIA,
						'default' => [
							'url' => \Elementor\Utils::get_placeholder_image_src(),
						],
						'dynamic' => [ 'active' => true ],
					],	
					[
						'name'        => 'tab_thumbnail',
						'label'       => esc_html__( 'Thumbnail', 'advkt-elementor' ),
						'type' => \Elementor\Controls_Manager::MEDIA,
						'default' => [
							'url' => \Elementor\Utils::get_placeholder_image_src(),
						],
						'dynamic' => [ 'active' => true ],
					],	
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'advkt-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'advkt-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->end_controls_section();


		/** typography **/
		$this->start_controls_section(
			'Content_style',
			[
				'label' => esc_html__( 'Content Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
            'content_color',
            [
                'label' => __( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .portfolio-card-wrapper .portfolio-card.style-2 .content .short-desc' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'selector' => '{{WRAPPER}} .portfolio-card-wrapper .portfolio-card.style-2 .content .short-desc',
			]
		);


		$this->end_controls_section();

		/** heading typography **/
		$this->start_controls_section(
			'year_style',
			[
				'label' => esc_html__( 'Year Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
            'year_color',
            [
                'label' => __( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .portfolio-card-wrapper .portfolio-card.style-2 .number-text' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'year_typography',
				'selector' => '{{WRAPPER}} .portfolio-card-wrapper .portfolio-card.style-2 .number-text',
			]
		);

		$this->end_controls_section();
	}

	public function render() {
		$settings  = $this->get_settings_for_display(); 
		extract($settings); ?>

		<div class="company-history-area">
			<div class="container">
				<div class="row">
					<div class="col-12">
						<div class="portfolio-card-wrapper">



							<?php 
							foreach ( $settings['tabs'] as $item ) :
								extract( $item );?>
								<div class="portfolio-card style-2">
									<div class="brand-logo">
										<?php
										if ( '' !== $tab_icon['id'] )  :  
											$tab_icon_src = wp_get_attachment_image_src( $tab_icon['id'], 'full' );
											$tab_icon_url = $tab_icon_src ? $tab_icon_src[0] : '';
										?>                        	
											<img src="<?php print esc_url($tab_icon_url); ?>" alt="Brand Logo">
										<?php 
										endif; ?>


									</div>
									<div class="content">
										<?php
										if( $tab_content !== "" ): ?>
											<span class="short-desc"><?php echo $tab_content; ?></span>
										<?php
										endif; ?>

										<div class="image">
											<?php
											if ( '' !== $tab_thumbnail['id'] )  :  
												$tab_thumbnail_image_src = wp_get_attachment_image_src( $tab_thumbnail['id'], 'full' );
												$tab_image_url = $tab_thumbnail_image_src ? $tab_thumbnail_image_src[0] : '';
												?>                        	
												<img src="<?php print esc_url($tab_image_url); ?>" alt="Brand Logo">
											<?php 
											endif; ?>
										</div>
									</div>

									<?php
									if( $tab_year !== "" ): ?>
										<span class="number-text"><?php echo $tab_year; ?></span>
									<?php
									endif; ?>
								</div>
								<?php
							endforeach;
							?>

						</div>
					</div>
				</div>
			</div>
		</div>


	<?php
	}
}