<?php
namespace AdvktElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Advkt Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class AdvktFancyIcon extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Advkt Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'advkt-fancy-icon';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Advkt Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'AT Fancy Icon', 'advkt-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Boomdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-history';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Boomdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'advkt-elementor' ];
	}

	public function get_keywords() {
		return [ 'fancy icon' ];
	}

	public function get_script_depends() {
		return [ 'advkt-elementor'];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content_section',
			[
				'label' => esc_html__( 'Section', 'advkt-elementor' ),
			]
		);

		$this->add_control(
			'icon',
			[
				'label'       => __( 'Icon', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter icon name', 'advkt-elementor' ),
				'default'     => __( 'fa-sharp fa-solid fa-heart', 'advkt-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'number',
			[
				'label'       => __( 'Number', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your heading', 'advkt-elementor' ),
				'default'     => __( 'Know More <span>Detail</span> About<br />Our <span>Company</span>', 'advkt-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your heading', 'advkt-elementor' ),
				'default'     => __( 'Know More <span>Detail</span> About<br />Our <span>Company</span>', 'advkt-elementor' ),
				'label_block' => true,
			]
		);	

        $this->add_control(
			'content',
			[
				'label'       => __( 'Content', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your content', 'advkt-elementor' ),
				'default'     => __( 'Law firms are typically structured with partners, associates, and support staff.
                Partners are senior attorneys. ', 'advkt-elementor' ),
				'label_block' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'advkt-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'advkt-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->add_control(
			'show_icon',
			[
				'label'   => esc_html__( 'Show Icon', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);	


		$this->add_control(
			'show_number',
			[
				'label'   => esc_html__( 'Show Number', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);	

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show title', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);		

		$this->add_control(
			'show_content',
			[
				'label'   => esc_html__( 'Show Content', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);		

		$this->end_controls_section();


		/** typography **/
		$this->start_controls_section(
			'fancy_heading_style',
			[
				'label' => esc_html__( 'Heading Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
            'fancy_heading_color',
            [
                'label' => __( 'Heading Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .icon-card.style-1 .content h3.title' => 'color: {{VALUE}};',
                ]
            ]
        );


		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'fancy_heading_typography',
				'selector' => '{{WRAPPER}} .icon-card.style-1 .content h3.title',
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'fancy_desc_style',
			[
				'label' => esc_html__( 'Description Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
            'fancy_desc_color',
            [
                'label' => __( 'Description Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .icon-card.style-1 .content p.desc' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'fancy_desc_typography',
				'selector' => '{{WRAPPER}} .icon-card.style-1 .content p.desc',
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'fancy_number_style',
			[
				'label' => esc_html__( 'Number Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
            'fancy_number_color',
            [
                'label' => __( 'Number Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .icon-card.style-1 .icon span' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'fancy_number_typography',
				'selector' => '{{WRAPPER}} .icon-card.style-1 .icon span',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'fancy_icon_style',
			[
				'label' => esc_html__( 'Icon Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
            'fancy_icon_color',
            [
                'label' => __( 'Icon Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .icon-card.style-1 .icon i' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'fancy_icon_typography',
				'selector' => '{{WRAPPER}} .icon-card.style-1 .icon i',
			]
		);


		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'fancy_icon_border_style',
				'selector' => '{{WRAPPER}} .icon-card.style-1 .icon',
			]
		);

		
	
		$this->end_controls_section();
	}

	public function render() {
		$settings  = $this->get_settings_for_display(); 
		extract($settings); ?>




        <div class="icon-card style-1">
            <div class="icon">
                <?php 
                if ( '' !== $settings['icon'] )  : ?>
                    <div class="counter-shape">
						<i class="<?php echo esc_attr( $icon ); ?>"></i>
                    </div>					
                <?php 
                endif; ?>
                
                <?php 
                if (( '' !== $number ) && ( $show_number )) : ?>
                    <span><?php print wp_kses_post( $number ); ?></span>
                <?php 
                endif; ?>
            </div>
            <div class="content">
                <?php 
                if (( '' !== $heading ) && ( $show_heading )) : ?>
                    <h3 class="title"><?php print wp_kses_post( $heading ); ?></h3>
                <?php 
                endif; ?>

                <?php 
                if (( '' !== $content ) && ( $show_content )) : ?>
                    <p class="desc"><?php print wp_kses_post( $content ); ?></p>
                <?php 
                endif; ?>
            </div>
        </div>

	<?php
	}
}