<?php
namespace AdvktElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Advkt Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class AdvktExpertise extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Advkt Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'advkt-expertise';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Advkt Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'At Expertise', 'advkt-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Boomdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-carousel-loop';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Boomdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'advkt-elementor' ];
	}

	public function get_keywords() {
		return [ 'expertise' ];
	}

	public function get_script_depends() {
		return [ 'advkt-elementor'];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'expertise_section',
			[
				'label' => esc_html__( 'Expertise Section', 'advkt-elementor' ),
			]
		);

		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Chose Style', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'expertise-style-1'  => esc_html__( 'Expertise Style 1', 'advkt-elementor' ),
					'expertise-style-2'  => esc_html__( 'Expertise Style 2', 'advkt-elementor' ),
				],
				'default'   => 'expertise-style-1',
			]
		);



		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Expertise Items', 'advkt-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'heading'   => esc_html__( 'Expertise #1', 'advkt-elementor' ),
					],
				],
				'fields' => [	
					[
						'name'       => 'heading',
						'label'      => esc_html__( 'Heading', 'advkt-elementor' ),
						'type'       => Controls_Manager::TEXT,
						'dynamic'    => [ 'active' => true ],
						'default'	 => 'Expert Doctors',
						'placeholder' => 'Content Here..',
						'show_label' => true,
						'label_block' => true,
					],
					[
						'name'       => 'icon',
						'label'      => esc_html__( 'Icon', 'advkt-elementor' ),
						'type'       => Controls_Manager::TEXT,
						'dynamic'    => [ 'active' => true ],
						'default'	 => '*',
						'placeholder' => 'Icon Here..',
						'show_label' => true,
						'label_block' => true,
					],
				],
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'advkt-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'advkt-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		);


		$this->end_controls_section();

		/** typography heading **/
		$this->start_controls_section(
			'expertise_heading_style',
			[
				'label' => esc_html__( 'Heading Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'expertise_typography',
				'selector' => '{{WRAPPER}} .brand-marquee-wrapper .single-brand-marquee span.brand-marquee-title',
			]
		);

		$this->add_control(
			'expertise_heading_color',
			[
				'label' => __( 'Color', 'advkt-elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .brand-marquee-wrapper .single-brand-marquee span.brand-marquee-title' => 'color: {{VALUE}};',
				],
				'condition' => [
					'chose_style' => ['expertise-style-1']
				],
			]
		);

		$this->add_control(
			'expertise_heading_even_color',
			[
				'label' => __( 'Even Color', 'advkt-elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .brand-marquee-area .brand-marquee-wrapper.second-brand-marquee .single-brand-marquee:nth-child(even) .brand-marquee-title' => 'color: {{VALUE}};',
				],
				'condition' => [
					'chose_style' => ['expertise-style-2']
				],
			]
		);

		$this->add_control(
			'expertise_heading_odd_color',
			[
				'label' => __( 'Odd Color', 'advkt-elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .brand-marquee-area .brand-marquee-wrapper.second-brand-marquee .single-brand-marquee:nth-child(odd) .brand-marquee-title' => 'color: {{VALUE}};',
				],
				'condition' => [
					'chose_style' => ['expertise-style-2']
				],
			]
		);



		$this->end_controls_section();

		/** typography icon **/
		$this->start_controls_section(
			'expertise_heading_icon_style',
			[
				'label' => esc_html__( 'Icon Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'expertise_heading_icon_size',
			[
				'label' => __( 'Font Size', 'advkt-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .brand-marquee-wrapper .single-brand-marquee span.brand-marquee-star' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'expertise_heading_icon_color',
			[
				'label' => __( 'Icon Color', 'advkt-elementor' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .brand-marquee-wrapper .single-brand-marquee span.brand-marquee-star' => 'color: {{VALUE}};',
				]
			]
		);

		$this->end_controls_section();

		

	}

	public function render() {
		$settings  = $this->get_settings_for_display(); 
		extract($settings);

		if( $chose_style == 'expertise-style-1' ): ?>
				
                <div class="brand-marquee-wrapper first-brand-marquee">
					<?php 
					foreach ( $settings['tabs'] as $item ) : 
						extract($item);
						?>
						<div class="single-brand-marquee">
							<?php
							if( '' !== $heading ): ?>
								<span class="brand-marquee-title"><?php print wp_kses_post( $heading ); ?></span>
							<?php
							endif; ?>

							<span class="brand-marquee-star"><?php echo wp_kses_post( $icon ); ?></span>
						</div>
					<?php
					endforeach;
					?>
                </div>

		<?php 
		elseif( $chose_style == 'expertise-style-2' ): ?>  
			
			<div class="brand-marquee-area style-2">
				<div class="brand-marquee-wrapper second-brand-marquee">

					<?php 
					foreach ( $settings['tabs'] as $item ) : 
					extract($item); ?>
						<div class="single-brand-marquee">
							<?php
							if( '' !== $heading ): ?>
								<span class="brand-marquee-title"><?php print wp_kses_post( $heading ); ?></span>
							<?php
							endif; ?>
							<span class="brand-marquee-star"><?php echo wp_kses_post( $icon ); ?></span>
						</div>
					<?php
					endforeach;
					?>
				</div>
			</div>

		<?php 
		endif; ?>      
	<?php
	}
}