<?php
namespace AdvktElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Advkt Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class AdvktExperience extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Advkt Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'advkt-experience';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Advkt Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'AT Experience', 'advkt-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Boomdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-history';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Boomdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'advkt-elementor' ];
	}

	public function get_keywords() {
		return [ 'experience' ];
	}

	public function get_script_depends() {
		return [ 'advkt-elementor'];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content_section',
			[
				'label' => esc_html__( 'Section', 'advkt-elementor' ),
			]
		);

		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Chose Style', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'experience-style-1'  => esc_html__( 'Experience Style 1', 'advkt-elementor' ),
					'experience-style-2' => esc_html__( 'Experience Style 2', 'advkt-elementor' ),
				],
				'default'   => 'experience-style-1',
			]
		);



		$this->add_control(
			'icon',
			[
				'label'       => __( 'Icon', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your icon', 'advkt-elementor' ),
				'default'     => __( '+', 'advkt-elementor' ),
				'label_block' => true,
				// 'condition' => [
				// 	'chose_style' => ['experience-style-2']
				// ],
			]
		);

        $this->add_control(
			'shape',
			[
				'label'   => esc_html__( 'Shape Image', 'advkt-elementor' ),
				'description' => esc_html__( 'Add Video Preview Image From Here', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'dynamic' => [ 'active' => true ],
			]
		);

        $this->add_control(
			'thumb',
			[
				'label'   => esc_html__( 'Thumb Image', 'advkt-elementor' ),
				'description' => esc_html__( 'Add Video Preview Image From Here', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'dynamic' => [ 'active' => true ],
				'condition' => [
					'chose_style' => ['experience-style-2']
				],
			]
		);

		$this->add_control(
			'number',
			[
				'label'       => __( 'Number', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your heading', 'advkt-elementor' ),
				'default'     => __( 'Know More <span>Detail</span> About<br />Our <span>Company</span>', 'advkt-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your heading', 'advkt-elementor' ),
				'default'     => __( 'Know More <span>Detail</span> About<br />Our <span>Company</span>', 'advkt-elementor' ),
				'label_block' => true,
			]
		);	

        $this->add_control(
			'content',
			[
				'label'       => __( 'Content', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your content', 'advkt-elementor' ),
				'default'     => __( 'Law firms are typically structured with partners, associates, and support staff.
                Partners are senior attorneys. ', 'advkt-elementor' ),
				'label_block' => true,
				'condition' => [
					'chose_style' => ['experience-style-2']
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'advkt-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'advkt-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->add_control(
			'show_icon',
			[
				'label'   => esc_html__( 'Show Icon', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);	

		$this->add_control(
			'show_thumb',
			[
				'label'   => esc_html__( 'Show Icon Image', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);	

		$this->add_control(
			'show_number',
			[
				'label'   => esc_html__( 'Show Number', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);	

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show title', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);		

		$this->add_control(
			'show_content',
			[
				'label'   => esc_html__( 'Show Content', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);		

		$this->end_controls_section();


		/** typography **/
		$this->start_controls_section(
			'experience_heading_style',
			[
				'label' => esc_html__( 'Heading Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
            'experience_heading_color',
            [
                'label' => __( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .counter-card h3.title' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'fancy_heading_typography',
				'selector' => '{{WRAPPER}} .counter-card h3.title',
			]
		);

		$this->end_controls_section();

		/** Number typography **/
		$this->start_controls_section(
			'experience_number_style',
			[
				'label' => esc_html__( 'Number Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		

		$this->add_control(
            'experience_number_color',
            [
                'label' => __( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .counter-card .number span' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'experience_number_typography',
				'selector' => '{{WRAPPER}} .counter-card .number span',
			]
		);


		$this->add_responsive_control(
			'experience_bg_color',
			[
				'label' => esc_html__( 'Background Color', 'advkt-elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .counter-card .number' => 'background-color: {{VALUE}} !important',
				],
			]
		);
		
		$this->end_controls_section();

		/** Section typography **/
		$this->start_controls_section(
			'experience_section_style',
			[
				'label' => esc_html__( 'Section Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'experience_sec_border_style',
				'selector' => '{{WRAPPER}} .counter-card',
			]
		);

		$this->add_responsive_control(
			'experience_sec_bg_color',
			[
				'label' => esc_html__( 'Background Color', 'advkt-elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .counter-card' => 'background-color: {{VALUE}} !important',
				],
			]
		);

		$this->add_responsive_control(
			'experience_sec_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'advkt-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .counter-card' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'experience_sec_margin',
			[
				'label' => esc_html__( 'Margin', 'advkt-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .counter-card' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'experience_sec_padding',
			[
				'label' => esc_html__( 'Padding', 'advkt-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .counter-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


		$this->end_controls_section();
				
	}

	public function render() {
		$settings  = $this->get_settings_for_display(); 
		extract($settings); 

		if( $chose_style == 'experience-style-1' ): ?>


			<div class="counter-card">
				<?php 
				if ( '' !== $settings['shape']['url'] && ('' !== $show_thumb))  : 
					$shape_image_src = wp_get_attachment_image_src( $settings['shape']['id'], 'full' );
					$shape_image_url = $shape_image_src ? $shape_image_src[0] : ''; 
					?>
					<div class="counter-shape">
						<img src="<?php echo esc_url($shape_image_url); ?>" alt="image">
					</div>
				<?php 
				endif; ?>

				<?php 
				if (( '' !== $number ) && ( $show_number )) : ?>
					<h2 class="number">
						<span class="counter"><?php print wp_kses_post( $number ); ?></span>
						<?php
						if(  ('' !== $icon) && ( $show_icon ) ): ?>
							<span><?php echo wp_kses_post( $icon ); ?></span>
						<?php
						endif; ?>
					</h2>    
				<?php 
				endif; ?>

				<?php 
				if (( '' !== $heading ) && ( $show_heading )) : ?>
					<h3 class="title"><?php print wp_kses_post( $heading ); ?></h3>
				<?php 
				endif; ?>
			</div>

		<?php 
		elseif( $chose_style == 'experience-style-2' ): ?>
			<div class="main-img-inner">
				<?php 
				if ( '' !== $settings['thumb']['url'] )  : 
					$thumbnail_small_image_src = wp_get_attachment_image_src( $settings['thumb']['id'], 'full' );
					$thumbnail_small_image_url = $thumbnail_small_image_src ? $thumbnail_small_image_src[0] : ''; 
					?>
					<img src="<?php echo esc_url($thumbnail_small_image_url); ?>" alt="image">
				<?php 
				endif; ?>
				<div class="company-label-wrapper">
					<div class="company-label">
						<div class="circle-rotate-wrapper">
							<div class="circle-rotate-inner">
								<?php 
								if (( '' !== $heading ) && ( $show_heading )) : ?>
									<div class="circle-rotate-text" data-circle-text='{"radius": 90, "forceWidth": true,"forceHeight": true}'>
										<?php print wp_kses_post( $heading ); ?>
									</div>	
								<?php 
								endif; ?>
							</div>
						</div>
						<div class="icon">
							<div class="counter-wrapper">
								<div class="number">
									<?php 
									if (( '' !== $number ) && ( $show_number )) : ?>
										<span class="counter"><?php print wp_kses_post( $number ); ?></span>
									<?php 
									endif; ?>
									<?php
									if(  ('' !== $icon) && ( $show_icon ) ): ?>
										<span class="prefix"><?php echo wp_kses_post( $icon ); ?></span>
									<?php
									endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		<?php
		endif; ?>

	<?php
	}
}