<?php
namespace AdvktElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Advkt Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class AdvktCompanyInfo extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Advkt Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'advkt-company-info';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Advkt Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'AT Company Info', 'advkt-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Boomdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-history';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Boomdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'advkt-elementor' ];
	}

	public function get_keywords() {
		return [ 'company info' ];
	}

	public function get_script_depends() {
		return [ 'advkt-elementor'];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content_section',
			[
				'label' => esc_html__( 'Section', 'advkt-elementor' ),
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your heading', 'advkt-elementor' ),
				'default'     => __( '$5 Billion', 'advkt-elementor' ),
				'label_block' => true,
			]
		);	

        $this->add_control(
			'content',
			[
				'label'       => __( 'Content', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your content', 'advkt-elementor' ),
				'default'     => __( 'Recovered for Our Clients', 'advkt-elementor' ),
				'label_block' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'advkt-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'advkt-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show title', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);		

		$this->add_control(
			'show_content',
			[
				'label'   => esc_html__( 'Show Content', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);		

		$this->end_controls_section();


		/** typography **/
		$this->start_controls_section(
			'heading_style',
			[
				'label' => esc_html__( 'Heading Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
            'heading_font_color',
            [
                'label' => __( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .single-info .title' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'heading_typography',
				'selector' => '{{WRAPPER}} .single-info .title',
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'content_style',
			[
				'label' => esc_html__( 'Content Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
            'content_font_color',
            [
                'label' => __( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .single-info .sub-title' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'selector' => '{{WRAPPER}} .single-info .sub-title',
			]
		);
		
		$this->end_controls_section();
	}

	public function render() {
		$settings  = $this->get_settings_for_display(); 
		extract($settings); ?>

            <div class="single-info">
                <?php 
				if (( '' !== $heading ) && ( $show_heading )) : ?>
					<h4 class="title"><?php print wp_kses_post( $heading ); ?></h4>
				<?php 
				endif; ?>
                <?php 
				if (( '' !== $content ) && ( $show_content )) : ?>
                    <span class="sub-title"><?php print wp_kses_post( $content ); ?></span>
                <?php
                endif; ?>
            </div>
	<?php
	}
}