<?php
namespace AdvktElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Advkt Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class AdvktAbout extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Advkt Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'advkt-about';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Advkt Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'AT About', 'advkt-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Boomdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-post-info';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Boomdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'advkt-elementor' ];
	}

	public function get_keywords() {
		return [ 'about' ];
	}

	public function get_script_depends() {
		return [ 'advkt-elementor'];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content_features',
			[
				'label' => esc_html__( 'About', 'advkt-elementor' ),
			]	
		);

		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Chose Style', 'advkt-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'about-style-1'  => esc_html__( 'About Style 1', 'advkt-elementor' ),
					'about-style-2'  => esc_html__( 'About Style 2', 'advkt-elementor' ),
					'about-style-3'  => esc_html__( 'About Style 3', 'advkt-elementor' )
				],
				'default'   => 'about-style-1',
			]
		);

		$this->add_control(
			'sub_heading',
			[
				'label'       => __( 'Sub Heading', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your sub heading', 'advkt-elementor' ),
				'default'     => __( 'It is sub heading', 'advkt-elementor' ),
				'label_block' => true,
				'condition' => [
					'chose_style' => ['about-style-2']
				],
			]
		);	
        

		$this->add_control(
			'before_heading',
			[
				'label'       => __( 'Before Heading', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your before heading', 'advkt-elementor' ),
				'default'     => __( 'It is before heading', 'advkt-elementor' ),
				'label_block' => true,
			]
		);	
        
		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your heading', 'advkt-elementor' ),
				'default'     => __( 'It is Heading', 'advkt-elementor' ),
				'label_block' => true,
			]
		);	
        
        $this->add_control(
			'after_heading',
			[
				'label'       => __( 'After Heading', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your sub heading', 'advkt-elementor' ),
				'default'     => __( 'It is sub heading', 'advkt-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'content',
			[
				'label'       => __( 'Content', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your heading', 'advkt-elementor' ),
				'default'     => __( 'It is content', 'advkt-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'quote_text',
			[
				'label'       => __( 'Quote Text', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your heading', 'advkt-elementor' ),
				'default'     => __( 'Attorney Generel and Criminal Lawyer', 'advkt-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'key_image',
			[
				'label'   => esc_html__( 'Heading Key Word Image', 'advkt-elementor' ),
				'description' => esc_html__( 'Add Your Shape Image', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'dynamic' => [ 'active' => true ],
			]
		);

		$this->add_control(
			'thumbnail',
			[
				'label'   => esc_html__( 'Thumbnail Image', 'advkt-elementor' ),
				'description' => esc_html__( 'Add Thumbnail Image', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'dynamic' => [ 'active' => true ],
				'condition' => [
					'chose_style' => ['about-style-2']
				],
			]
		);


		$this->end_controls_section();


		/** 
		*	Link section 
		**/
		$this->start_controls_section(
			'link_section_content',
			[
				'label' => esc_html__( 'Link Info', 'advkt-elementor' ),
				'condition' => [
					'chose_style' => ['about-style-1', 'about-style-2', 'about-style-3']
				],
			]
		);		

		$this->add_control(
			'link_text',
			[
				'label'       => __( 'Link Text', 'advkt-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Type Link Text Here...', 'advkt-elementor' ),
				'default'     => __( 'Learn More', 'advkt-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'link',
			[
				'label' => __( 'Link', 'advkt-elementor' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'advkt-elementor' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
	
		$this->end_controls_section();


	
		/** 
		*	Layout section 
		**/
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'advkt-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'advkt-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'advkt-elementor' ),
						'icon'  => 'eicon-text-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		);

		$this->add_control(
			'show_sub_heading',
			[
				'label'   => esc_html__( 'Show Sub Heading', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);			

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);			

		$this->add_control(
			'show_before_heading',
			[
				'label'   => esc_html__( 'Show Before Heading', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);		

		$this->add_control(
			'show_after_heading',
			[
				'label'   => esc_html__( 'Show After Heading Text', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);		

		$this->add_control(
			'show_quote_text',
			[
				'label'   => esc_html__( 'Show Quote Text', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);		

		$this->add_control(
			'show_content',
			[
				'label'   => esc_html__( 'Show Content', 'advkt-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);		
	

		$this->end_controls_section();
		
		/** subheading typography **/
		$this->start_controls_section(
			'about_sub_heading_style',
			[
				'label' => esc_html__( 'Sub Heading Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'chose_style' => ['about-style-2']
				],
			]
		);


		$this->add_control(
            'about_sub_heading_font_color',
            [
                'label' => __( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .el-section-title .el-sub-heading' => 'color: {{VALUE}} !important',
                ]
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'client_heading_typography',
				'selector' => '{{WRAPPER}} .el-section-title .el-sub-heading',
			]
		);

		$this->end_controls_section();

		/** heading typography **/
		$this->start_controls_section(
			'about_heading_style',
			[
				'label' => esc_html__( 'Heading Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);


		$this->add_control(
            'about_heading_font_color',
            [
                'label' => __( 'Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .el-section-title .el-heading' => 'color: {{VALUE}} !important',
                ]
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'about_heading_typography',
				'selector' => '{{WRAPPER}} .el-section-title .el-heading',
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'about_desc_style',
			[
				'label' => esc_html__( 'Description Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
            'about_desc_font_color',
            [
                'label' => __( 'Description Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .el-section-title .el-desc' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'about_desc_typography',
				'selector' => '{{WRAPPER}} .el-section-title .el-desc',
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'about_quotation_style',
			[
				'label' => esc_html__( 'Quotation Style', 'advkt-elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		
		$this->add_control(
            'about_quote_font_color',
            [
                'label' => __( 'Author Quote Color', 'advkt-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .about-info-card.style-1 .quote' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'about_quote_typography',
				'selector' => '{{WRAPPER}} .about-info-card.style-1 .quote',
			]
		);

		$this->add_responsive_control(
			'about_quote_bg_color',
			[
				'label' => esc_html__( 'Quote Background Color', 'advkt-elementor' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-info-card .about-info-content .quote::before' => 'background-color: {{VALUE}} !important',
				],
			]
		);

		$this->end_controls_section();


	/** Start Button **/
	$this->start_controls_section(
		'banner_btn_style',
		[
			'label' => esc_html__( 'Button Style', 'eyewell-elementor'),
			'tab' => Controls_Manager::TAB_STYLE,
			
		]
	);

	$this->start_controls_tabs(
		'style_tabs'
	);


	$this->start_controls_tab(
		'style_normal_tab',
		[
			'label' => esc_html__( 'Normal', 'textdomain' ),
		]
	);

	$this->add_group_control(
		Group_Control_Typography::get_type(),
		[
			'name' => 'banner_btn_typography',
			'selector' => '{{WRAPPER}} .theme-btn',
		]
	);
	

	$this->add_responsive_control(
		'banner_btn_text_color',
		[
			'label' => esc_html__( 'Text Color', 'eyewell-elementor' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .theme-btn' => 'color: {{VALUE}} !important',
			],
		]
	);
	
	$this->add_responsive_control(
		'banner_btn_bg_color',
		[
			'label' => esc_html__( 'Background Color', 'eyewell-elementor' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .theme-btn' => 'background: {{VALUE}} !important',
			],
		]
	);
	
	$this->add_responsive_control(
		'banner_btn_margin',
		[
			'label' => esc_html__( 'Margin', 'eyewell-elementor' ),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
			'selectors' => [
				'{{WRAPPER}} .theme-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);
	
	$this->add_responsive_control(
		'banner_btn_padding',
		[
			'label' => esc_html__( 'Padding', 'eyewell-elementor' ),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
			'selectors' => [
				'{{WRAPPER}} .theme-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);
	
	$this->add_group_control(
		Group_Control_Border::get_type(),
		[
			'name' => 'banner_btn_border_border',
			'selector' => '{{WRAPPER}} .theme-btn',
		]
	);
	
	$this->add_responsive_control(
		'banner_btn_border_radius',
		[
			'label' => esc_html__( 'Border Radius', 'eyewell-elementor' ),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
			'selectors' => [
				'{{WRAPPER}} .theme-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);

	$this->end_controls_tab();

	$this->start_controls_tab(
		'style_hover_tab',
		[
			'label' => esc_html__( 'Hover', 'textdomain' ),
		]
	);

	
	$this->add_responsive_control(
		'banner_btn_hover_color',
		[
			'label' => esc_html__( 'Color', 'eyewell-elementor' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .theme-btn:hover' => 'color: {{VALUE}} !important',
			],
		]
	);

	$this->add_responsive_control(
		'banner_btn_bg_hover_color',
		[
			'label' => esc_html__( 'Background Color', 'eyewell-elementor' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .theme-btn:hover' => 'background: {{VALUE}} !important',
			],
		]
	);

	$this->add_responsive_control(
		'banner_btn_icon_hover_color',
		[
			'label' => esc_html__( 'Icon Color', 'eyewell-elementor' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .theme-btn:hover i' => 'color: {{VALUE}} !important',
			],
		]
	);

	$this->end_controls_tab();

	$this->end_controls_section();



	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract($settings);

		$this->add_render_attribute(
			[
				'link' => [
					'href'   => !empty($settings['link']['url']) ? esc_url($settings['link']['url']) : '#',
					'target' => !empty($settings['link']['is_external']) ? '_blank' : '_self'
				]
			], '', '', true
		);


		
		if( $chose_style == 'about-style-1' ): ?>

            <div class="about-info-card style-1 el-section-title">
                <div class="about-info-content">
                    <div class="section-title ">
                        <div class="sec-content">
                            <h2 class="title el-heading text-white">
								<?php
								if ( ('' !== $before_heading ) &&  ( $settings['show_before_heading'] )) : 
									echo $before_heading; 
								endif; ?>

                                <span class="shape">
                                    <?php
									if ( ('' !== $heading ) &&  ( $settings['show_heading'] )) : ?>
										<?php echo $heading; ?>
									<?php
									endif; ?>

									<?php 
									if ( '' !== $settings['key_image']['url'] )  : 
										$thumbnail_small_image_src = wp_get_attachment_image_src( $settings['key_image']['id'], 'full' );
										$thumbnail_small_image_url = $thumbnail_small_image_src ? $thumbnail_small_image_src[0] : ''; 
										?>
										<img src="<?php echo esc_url($thumbnail_small_image_url); ?>" alt="image">
									<?php 
									endif; ?>
									
                                </span> <br/> 
								<?php
								if ( ('' !== $after_heading ) &&  ( $settings['show_after_heading'] )) : 
									echo $after_heading; 
								endif; ?>
                            </h2>
                        </div>
                    </div>

					<?php 
                    if ( ('' !== $quote_text) &&  ( $settings['show_quote_text'] )) : ?>
						<div class="quote">
							<?php echo wp_kses_post( $quote_text ); ?>
						</div>
					<?php
					endif; ?>

                    <?php 
                    if ( ('' !== $content) &&  ( $settings['show_content'] )) : ?>
                        <div class="desc-wrapper el-desc text-white">
                            <p class="desc el-desc"><?php echo wp_kses_post( $content ); ?></p>
                        </div>
                    <?php 
                    endif; ?>

                    <?php 
                    if (( ! empty( $settings['link']['url'] )) ): ?>
                        <div class="btn-wrapper">
                            <a <?php echo $this->get_render_attribute_string( 'link' ); ?> class="theme-btn text-black"><?php echo esc_html($settings['link_text']); ?></a>
                        </div>
                    <?php 
                    endif; ?>

                </div>
            </div>

		<?php 
		elseif( $chose_style == 'about-style-2' ): ?>
		
				<div class="section-title el-section-title">
                    <div class="sec-content">
						<?php
						if ( ('' !== $sub_heading ) &&  ( $settings['show_sub_heading'] )) : ?>
							<span class="short-title el-sub-heading"><?php echo $sub_heading; ?></span>
						<?php
						endif; ?>

                        <h2 class="title el-heading">
							<?php
							if ( ('' !== $before_heading ) &&  ( $settings['show_before_heading'] )) : 
								echo $before_heading; 
							endif; ?>

							<span class="shape">
								<?php
								if ( ('' !== $heading ) &&  ( $settings['show_heading'] )) : ?>
									<?php echo $heading; ?>
								<?php
								endif; ?>

								<?php 
								if ( '' !== $settings['key_image']['url'] )  : 
									$thumbnail_small_image_src = wp_get_attachment_image_src( $settings['key_image']['id'], 'full' );
									$thumbnail_small_image_url = $thumbnail_small_image_src ? $thumbnail_small_image_src[0] : ''; 
									?>
									<img src="<?php echo esc_url($thumbnail_small_image_url); ?>" alt="image">
								<?php 
								endif; ?>
							</span> <br/> 
							<?php
							if ( ('' !== $after_heading ) &&  ( $settings['show_after_heading'] )) : 
								echo $after_heading; 
							endif; ?>
						</h2>
                    </div>
                </div>

				<div class="about-info-card style-2 el-section-title">
                    <div class="thumbnail">
						<?php 
						if ( '' !== $settings['thumbnail']['url'] )  : 
							$thumbnail_image_src = wp_get_attachment_image_src( $settings['thumbnail']['id'], 'full' );
							$thumbnail_image_url = $thumbnail_image_src ? $thumbnail_image_src[0] : ''; 
							?>
							<img class="tilt-animate" src="<?php echo esc_url($thumbnail_image_url); ?>" alt="image">
						<?php 
						endif; ?>
                    </div>
					
                    <div class="about-info-content">
						<?php 
						if ( ('' !== $content) &&  ( $settings['show_content'] )) : ?>
							<div class="desc-wrapper el-desc">
								<?php echo wp_kses_post( $content ); ?>
							</div>
						<?php 
						endif; ?>

						<?php 
						if (( ! empty( $settings['link']['url'] )) ): ?>
							<div class="btn-wrapper">
								<a <?php echo $this->get_render_attribute_string( 'link' ); ?> class="theme-btn text-black"><?php echo esc_html($settings['link_text']); ?></a>
							</div>
						<?php 
						endif; ?>
                    </div>
                </div>

		<?php 
		endif; ?>	
	<?php
	}
}